/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class UpdateSpillingFluidsPacket
implements ISimplePacket {
    private final List<SpillingFluid> fluids;

    public UpdateSpillingFluidsPacket(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ImmutableList.Builder fluids = ImmutableList.builder();
        List<ISpillingEffect> effects = Collections.singletonList(NoEffect.INSTANCE);
        for (int i = 0; i < size; ++i) {
            fluids.add((Object)new SpillingFluid(FluidIngredient.read((FriendlyByteBuf)buf), effects));
        }
        this.fluids = fluids.build();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.fluids.size());
        for (SpillingFluid fluid : this.fluids) {
            fluid.ingredient().write(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        SpillingFluidManager.INSTANCE.updateFromServer(this.fluids);
    }

    public UpdateSpillingFluidsPacket(List<SpillingFluid> fluids) {
        this.fluids = fluids;
    }

    private static class NoEffect
    implements ISpillingEffect {
        private static final ISpillingEffect INSTANCE = new NoEffect();

        private NoEffect() {
        }

        @Override
        public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        }

        public JsonObject serialize(JsonSerializationContext context) {
            throw new UnsupportedOperationException("Cannot serialize spilling fluids on the client");
        }
    }
}

